define([
    'underscore',
    'jquery',
    'models/abstract-model',
], function(_, $, Model) {
    'use strict';


    return Model.extend({
        constructor: function() {
            this._isReady = new $.Deferred();

            this.isReady = this._isReady.promise();
            this.isReady.success = this.isReady.done;
            this.isReady.error = this.isReady.fail;

            Model.prototype.constructor.apply(this, arguments);
        },

        defaultsFetchOptions: {},

        url: function() {
            var resource = this.getResource();
            return resource.formatHref();
        },

        fetch: function(options) {
            if (_.isUndefined(this.xhr)) {
                if (_.isUndefined(this._lastFetchOptions)) {
                    this._lastFetchOptions = _.extend({}, this.defaultsFetchOptions, options);
                }

                this.xhr = Model.prototype.fetch.call(this, this._lastFetchOptions);
                this.xhr.success(_.bind(this._onSuccess, this));
                this.xhr.error(_.bind(this._onError, this));
            }
            return this.isReady;
        },

        _onSuccess: function() {
            this.trigger('fetch:success');
            this._isReady.resolve.apply(this, arguments);
        },

        _onError: function() {
            this.trigger('fetch:error');
            this._isReady.reject.apply(this, arguments);
        },
    });
});
